package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.annotation.Nullable;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author fumingkun
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretBatchQueryParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = 3491253223016071364L;


    /**
     * 创建时间-开始
     */
    @Nullable
    private Date createTimeStart;

    /**
     * 创建时间-结束
     */
    @Nullable
    private Date createTimeEnd;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 卡密商品ID
     */
    private Long spuId;

    /**
     * 生效时间 - 开始
     */
    private String effectiveTimeStart;

    /**
     * 生效时间 - 结束
     */
    private String effectiveTimeEnd;

    /**
     * 失效时间 - 开始
     */
    private String expirationTimeStart;

    /**
     * 失效时间 - 结束
     */
    private String expirationTimeEnd;

    /**
     * 创建人操作Id
     */
    private Long creatorId;

    /**
     * 当前需求商品主键, tb_demand_goods.id,b
     */
    private List<Long> demandGoodsIds;

    /**
     * 状态 0-未启用 1-启用
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer batchStatus;

}
