package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier.callback;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.callback.SupplierOrderMeiTuanCouponCallbackDto;
import cn.com.duiba.quanyi.goods.service.api.param.order.supplier.callback.SupplierOrderMeiTuanCouponCallbackSearchParam;
import java.util.List;

/**
 * 美团支付券回调记录表
 * @author kjj mybatis generator 
 * @date 2024-09-19
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderMeiTuanCouponCallbackService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 美团支付券回调记录集合
     */
    List<SupplierOrderMeiTuanCouponCallbackDto> selectPage(SupplierOrderMeiTuanCouponCallbackSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierOrderMeiTuanCouponCallbackSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 美团支付券回调记录
     */
    SupplierOrderMeiTuanCouponCallbackDto selectById(Long id);

    /**
     * 新增
     * @param dto 美团支付券回调记录
     * @return 影响行数
     */
    int insert(SupplierOrderMeiTuanCouponCallbackDto dto);

    /**
     * 更新
     * @param dto 美团支付券回调记录
     * @return 影响行数
     */
    int update(SupplierOrderMeiTuanCouponCallbackDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 影响行数
     */
    int delete(Long id);
}