package cn.com.duiba.quanyi.goods.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierDto;
import cn.com.duiba.quanyi.goods.service.api.param.supplier.SupplierSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 供应商表
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteSupplierService {

    /**
     * 根据条件查询，不分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 供应商集合
     */
    List<SupplierDto> selectList(SupplierSearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 供应商集合
     */
    List<SupplierDto> selectPage(SupplierSearchParam param);

    /**
     * 根据条件,查询记录的总记录数，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SupplierSearchParam param);

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 供应商
     */
    SupplierDto selectById(Long id);

    /**
     * 根据主键批量查询
     *
     * @param ids 主键列表
     * @return 供应商列表
     */
    List<SupplierDto> selectByIds(Set<Long> ids);

    /**
     * 新增
     *
     * @param dto 供应商
     * @return 主键
     */
    Long insert(SupplierDto dto);

    /**
     * 更新
     *
     * @param dto 供应商
     * @return 影响行数
     */
    int update(SupplierDto dto);
}