package cn.com.duiba.quanyi.goods.service.api.param.goods;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author nongfu
 * @Date 2024/10/26 14:11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString(callSuper =true)
public class PurchaseSpuSearchEsParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = -7553280028127297690L;
    /**
     * 主键，编辑时必填
     */

    private Long id;
    /**
     * 商品名称
     */
    private String purchaseSpuName;
    /**
     * 商品类型，1-实物，2-快捷支付，3-直充，4-卡密，5-汽车服务
     */
    private Integer purchaseSpuType;
    /**
     * 创建人ID
     */
    private Long createOperatorId;
    /**
     * 商品状态：0-停用，1-启用
     */
    private Integer purchaseSpuStatus;
    /**
     * 供应商ID
     */
    private Long supplierId;
    /**
     * 分类ID
     */
    private List<Long> goodsClassIds;

    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;



}
