package cn.com.duiba.quanyi.goods.service.api.remoteservice.bill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.bill.AlipayCouponBillDto;

/**
 * 支付宝立减金核销记录表
 *
 * @author kjj mybatis generator
 * @date 2023-12-20
 */
@AdvancedFeignClient
public interface RemoteAlipayCouponBillService {

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 支付宝立减金核销记录
     */
    AlipayCouponBillDto selectById(Long id);

    /**
     * 新增
     *
     * @param dto 支付宝立减金核销记录
     * @return 影响行数
     */
    Long insert(AlipayCouponBillDto dto);

    /**
     * 更新
     *
     * @param dto 支付宝立减金核销记录
     * @return 影响行数
     */
    int update(AlipayCouponBillDto dto);
}