package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request;

import lombok.Data;

import java.io.Serializable;

/**
 * 订单创建公共参数
 *
 * @author guoyanfei
 * @date 2023/1/11
 */
@Data
public class BaseOrderCreateReq<E extends BaseOrderCreateExtReq> implements Serializable {

    private static final long serialVersionUID = 569628382869087270L;

    /**
     * spuId，有skuId时，spuId就不需要传入了
     */
    private Long spuId;

    /**
     * skuId，有skuId时，spuId就不需要传入了
     */
    private Long skuId;

    /**
     * 订单价格，单位分
     */
    private Integer orderPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 备注，买家留言
     */
    private String remark;

    /**
     * 订单是否已确认完毕
     * true-已确认完毕
     * false-未确认完毕。比如需要审核
     */
    private Boolean confirmed;

    /**
     * 获取商品类型
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SpuTypeEnum
     */
    private Integer spuType;


    /**
     * 扩展信息
     */
    private E ext;
}

