package cn.com.duiba.quanyi.goods.service.api.dto.order.supplier.callback;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 美团支付券回调记录表
 * @author kjj mybatis generator 
 * @date 2024-09-19
 */
@Data
public class SupplierOrderMeiTuanCouponCallbackDto implements Serializable {
     
    private static final long serialVersionUID = 17267408792069463L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户订单号
     */
    private String customerOrderNo;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 通知流水号
     */
    private String notifyId;

    /**
     * 商户ID
     */
    private String mchId;

    /**
     * 券码
     */
    private String couponCode;

    /**
     * 批次号ID
     */
    private String couponBatchId;

    /**
     * 事件类型 券变更类型：2-核销，3-退券，5-过期
     */
    private String eventType;

    /**
     * 券类型 券类型：1-支付券
     */
    private String couponType;

    /**
     * 优惠金额（分）
     */
    private String discountAmt;

    /**
     * 变更时间 格式：yyyy-MM-dd HH:mm:ss
     */
    private Date changeTime;

    /**
     * 通知时间 格式：yyyy-MM-dd HH:mm:ss
     */
    private Date notifyTime;

    /**
     * 回调信息json
     */
    private String callbackInfo;
}