package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.supplier;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.supplier.SupplierOrderAlipayCouponCallbackDto;

/**
 * 供应商订单-支付宝立减金扩展字段
 *
 * @author kjj mybatis generator
 * @date 2023-11-28
 */
@AdvancedFeignClient
public interface RemoteSupplierOrderAlipayCouponService {


    /**
     * 根据券id查询
     * @param voucherId
     * @return
     */
    List<SupplierOrderAlipayCouponCallbackDto> selectByVoucherId(String voucherId);


    /**
     * 根据订单号查询
     * @param orderNo
     * @return
     */
    List<SupplierOrderAlipayCouponCallbackDto> selectByOrderNo(String orderNo);

    /**
     * 根据订单号集合查询
     * @param orderNoList 订单号集合
     * @return 支付宝立减金回调记录DTO列表
     */
    List<SupplierOrderAlipayCouponCallbackDto> selectByOrderNoList(List<String> orderNoList);

}