package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 退回记录状态枚举
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Getter
@AllArgsConstructor
public enum ReturnedRecordStatusEnum {
    PENDING(1, "待退回"),
    PROCESSING(2, "退回中"),
    COMPLETED(3, "已完成"),
    FAILED(4, "退回失败"),
    CANCELLED(5, "已取消"),
    ;

    private final Integer code;
    private final String desc;

    public static ReturnedRecordStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (ReturnedRecordStatusEnum statusEnum : values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
