package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.io.Serializable;
import java.util.Set;

import lombok.Data;

/**
 * 卡密券批量查询参数
 *
 * @author yangyukang
 * @date 2025-09-25
 */
@Data
public class CardSecretCouponBatchQueryParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 批次id
     */
    private Long batchId;

    /**
     * 券码集合
     * 数量不能超过500
     */
    private Set<String> couponCodes;

    /**
     * 链接券集合
     * 数量不能超过500
     */
    private Set<String> linkCodes;

    /**
     * 账号集合
     * 数量不能超过500
     */
    private Set<String> accountNos;
}
