package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.kaishujiangushi.KaiShuJiangGuShiZcOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.kaishujiangushi.KaiShuJiangGuShiZcOrderResult;

/**
 * RemoteOrderProcessorKaiShuShuoGuShiZcService
 *
 * @author yangyk
 * @since 2024/8/2
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorKaiShuJiangGuShiZcService {

    /**
     * 下单
     *
     * @param req 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<KaiShuJiangGuShiZcOrderCreateReq> req);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    KaiShuJiangGuShiZcOrderResult findOrderResult(String customerOrderNo);
} 