package cn.com.duiba.quanyi.goods.service.api.dto.cardsecret;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 卡密采购单
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Data
public class CardSecretPurchaseOrderDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 关联的批次表ID
     */
    private Long batchId;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 成本价
     */
    private Integer costPrice;

    /**
     * 是否结算：0-不结算，1-结算
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer isSettled;

    /**
     * 备注
     */
    private String remark;

    /**
     * 采购数量
     */
    private Long purchaseQty;

    /**
     * 分配数量
     */
    private Long allocatedQty;

    /**
     * 已入库数量
     */
    private Long receivedQty;

    /**
     * 发起关联数量
     */
    private Long toLinkQty;

    /**
     * 已关联数量
     */
    private Long linkedQty;

    /**
     * 入库状态
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.ReceivingStatusEnum
     */
    private Integer receivingStatus;

}
