package cn.com.duiba.quanyi.goods.service.api.enums.car;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/8/5 16:39
 */
@Getter
@AllArgsConstructor
public enum CarSerPlatformTypeEnum {
    CAR_AFTER(1,"汽车服务-车后", "镁琪"),
    CAR_MOM(2,"汽车服务-车妈妈", "车妈妈"),
    CAR_EASY(3,"汽车服务-车行易", "车咖"),
    ;
    
    private final Integer type;
    
    private final String desc;

    /**
     * 用于展示和搜索
     */
    private final String aliasName;

    public static CarSerPlatformTypeEnum getByType(Integer type) {
        for (CarSerPlatformTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }

    public static CarSerPlatformTypeEnum getByAliasName(String aliasName) {
        for (CarSerPlatformTypeEnum value : values()) {
            if (value.getAliasName().equals(aliasName)) {
                return value;
            }
        }
        return null;
    }
}
