package cn.com.duiba.quanyi.goods.service.api.dto.goods;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Map;

/**
 * @author lizhi
 * @date 2023/11/22 11:34
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class SkuDetailDto extends SkuDto {

    private static final long serialVersionUID = -4673005182644306469L;

    /**
     * 剩余库存
     */
    private Long surplusNum;

    /**
     * 扩展信息
     * key：配置key，value：具体配置值
     *
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.SkuExtConfNameEnum#getName()
     */
    private Map<Integer, String> extMap;
}
