package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.io.Serializable;
import java.util.Set;

import org.apache.commons.collections4.CollectionUtils;

import lombok.Data;

/**
 * 卡密关联退回请求参数
 *
 * @author yangyukang
 * @date 2025-01-28
 */
@Data
public class CardSecretAssociationReturnParam implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 关联任务ID
     */
    private Long associationTaskId;

    /**
     * 退回数量
     */
    private Long returnQty;

    /**
     * 操作人ID
     */
    private Long operatorId;

    /**
     * 操作人姓名
     */
    private String operatorName;

    /**
     * 退回记录ID
     */
    private Long returnedRecordId;

    /**
     * 退回批次ID
     */
    private Long returnedBatchId;

    /**
     * 退回原因
     */
    private String remark;

    /**
     * 券码集合（coupon_code）
     */
    private Set<String> couponCodes;

    /**
     * 链接券集合（link_code）
     */
    private Set<String> linkCodes;

    /**
     * 账号集合（account_no）
     */
    private Set<String> accountNos;

    /**
     * 验证参数
     * 
     * @throws IllegalArgumentException 参数不合法时抛出
     */
    public void validate() {
        if (associationTaskId == null || associationTaskId <= 0) {
            throw new IllegalArgumentException("关联任务ID不能为空且必须大于0");
        }
        if (returnQty == null || returnQty <= 0) {
            throw new IllegalArgumentException("退回数量不能为空且必须大于0");
        }
        if (operatorId == null || operatorId <= 0) {
            throw new IllegalArgumentException("操作人ID不能为空且必须大于0");
        }
        if (operatorName == null || operatorName.trim().isEmpty()) {
            throw new IllegalArgumentException("操作人姓名不能为空");
        }
        if (returnedRecordId == null || returnedRecordId <= 0) {
            throw new IllegalArgumentException("退回记录ID不能为空且必须大于0");
        }
        if (returnedBatchId == null || returnedBatchId <= 0) {
            throw new IllegalArgumentException("退回批次ID不能为空且必须大于0");
        }
        // 验证券码集合
        if (CollectionUtils.isEmpty(couponCodes) && CollectionUtils.isEmpty(linkCodes) && CollectionUtils.isEmpty(accountNos)) {
            throw new IllegalArgumentException("券码、链接券、账号至少需要提供一种");
        }

        // 验证券码数量与退回数量一致
        int totalCouponCount = 0;
        if (CollectionUtils.isNotEmpty(couponCodes)) {
            totalCouponCount += couponCodes.size();
        }
        if (CollectionUtils.isNotEmpty(linkCodes)) {
            totalCouponCount += linkCodes.size();
        }
        if (CollectionUtils.isNotEmpty(accountNos)) {
            totalCouponCount += accountNos.size();
        }
        
        if (totalCouponCount != returnQty.intValue()) {
            throw new IllegalArgumentException("传入的券码总数量(" + totalCouponCount + ")与退回数量(" + returnQty + ")不一致");
        }
    }
}
