package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.object;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2024/2/23 14:03
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class ObjectOrderCreateReq extends BaseOrderCreateExtReq {
    
    private static final long serialVersionUID = -2334468795566978437L;

    /**
     * 是否订阅快递信息
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer subExpress;

    /**
     * 收货人姓名
     */
    private String name;

    /**
     * 收货人手机号
     */
    private String phone;

    /**
     * 收货地址 省份
     */
    private String province;

    /**
     * 收货地址 市
     */
    private String city;

    /**
     * 收货地址 区、县
     */
    private String district;

    /**
     * 收货地址 街道
     */
    private String street;

    /**
     * 收货详细地址
     */
    private String address;
}
