package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.car;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;

/**
 * @author lizhi
 * @date 2024/8/6 15:38
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class CarSerOrderCreateReq extends BaseOrderCreateExtReq {
    
    private static final long serialVersionUID = -8089297347989787810L;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 平台服务编码
     */
    private String platformCode;

    /**
     * 门店服务ID，兑吧门店必传
     * 传入门店服务ID时，可不传门店编码、平台服务编码
     */
    private Long storeSerId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 有效期天数
     * expireDays 与 verificationExpireTime 同时传时，以expireDays为准
     */
    private Integer expireDays;

    /**
     * 核销到期时间
     * expireDays 与 verificationExpireTime 同时传时，以expireDays为准
     */
    private Date verificationExpireTime;
}
