package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 关联任务状态枚举
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@Getter
@AllArgsConstructor
public enum AssociationTaskStatusEnum {
    PENDING(1, "待处理"),
    PROCESSING(2, "处理中"),
    COMPLETED(3, "已完成"),
    FAILED(4, "处理失败"),
    CANCELLED(5, "已取消"),
    ;

    private final Integer code;
    private final String desc;

    public static AssociationTaskStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (AssociationTaskStatusEnum statusEnum : values()) {
            if (statusEnum.getCode().equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
