package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretBatchEsDto;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretPurchaseOrderDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretPurchaseOrderPageParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretPurchaseOrderUpdateParam;

/**
 * 卡密采购单远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretPurchaseOrderService {

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    int update(CardSecretPurchaseOrderDto dto);

    /**
     * 更新采购单信息（推荐使用）
     * 包含Redis分布式锁控制、采购单入库数量更新、批次信息更新等完整业务流程
     *
     * @param param 卡密采购单更新参数，包含需要更新的字段信息
     * @return 影响行数
     * @throws BizException 业务异常
     */
    int updateWithLock(CardSecretPurchaseOrderUpdateParam param) throws BizException;

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretPurchaseOrderDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretPurchaseOrderDto
     */
    CardSecretPurchaseOrderDto selectById(Long id);


    /**
     * 根据批次ID查询
     *
     * @param batchId 批次ID
     * @return 采购单列表
     */
    List<CardSecretPurchaseOrderDto> selectByBatchId(Long batchId);

    /**
     * 根据供应商ID查询
     *
     * @param supplierId 供应商ID
     * @return 采购单列表
     */
    List<CardSecretPurchaseOrderDto> selectBySupplierId(Long supplierId);

    /**
     * 根据入库状态查询
     *
     * @param receivingStatus 入库状态
     * @return 采购单列表
     */
    List<CardSecretPurchaseOrderDto> selectByReceivingStatus(Integer receivingStatus);

    /**
     * 分页查询卡密采购单
     *
     * @param pageParam 分页查询参数
     * @return 卡密批次ES列表
     */
    Pair<Long, List<CardSecretBatchEsDto>> page(CardSecretPurchaseOrderPageParam pageParam);

    /**
     * 根据ID查询卡密采购单详情（ES查询）
     *
     * @param id 主键ID
     * @return 卡密批次ES详情
     */
    CardSecretBatchEsDto selectDetailById(Long id);

}

