package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.bawangchaji.BaWangChaJiCouponCancelReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.bawangchaji.BaWangChaJiOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.BaseResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;

/**
 * 订单-易安优酷
 */
@AdvancedFeignClient
public interface RemoteOrderProcessorBaWangChaJiService {

    /**
     * 下单
     *
     * @param dto 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<BaWangChaJiOrderCreateReq> dto);

    /**
     * 优惠券作废
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResult cancelCoupon(BaWangChaJiCouponCancelReq request);
}
