package cn.com.duiba.quanyi.goods.service.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 线下商品类型
 *
 * @author lizhi
 * @date 2023/11/20 11:46
 */
@Getter
@AllArgsConstructor
public enum OfflineGoodsTypeEnum {

    ADVANCE_MONEY_PURE(1,1, "垫资","纯打款垫资"),
    ADVANCE_MONEY_CLOUD_QUICK_PASS(2,1, "垫资","云闪付垫资"),
    ADVANCE_MONEY_BANK_CARD(3,1, "垫资","银行卡垫资"),
    ADVANCE_MONEY_NUMBER_COIN(4,1, "垫资","数币垫资"),
    ADVANCE_MONEY_ITEM_CARD(5,1, "垫资","道具卡垫资"),
    ADVANCE_MONEY_CCB_LIFE(6,1, "垫资","建行生活垫资"),
    TAO_BAO_MARKETING(7,2, "淘营销","淘营销"),
    CLOUD_QUICK_PASS(8,3, "云闪付","云闪付"),
    DOU_YIN(9,4, "抖音","抖音"),
    MEI_TUAN(10,5, "美团","美团"),
    ;

    /**
     * 枚举ID
     */
    private final Integer id;
    /**
     * 枚举类型
     * 1-垫资
     * 2-淘营销
     * 3-云闪付
     * 4-抖音
     * 5-美团
     */
    private final Integer type;

    /**
     * 枚举类型名称
     */
    private final String typeName;

    /**
     * 枚举描述
     */
    private final String desc;

    /**
     * 根据ID获取枚举
     */
    public static OfflineGoodsTypeEnum getById(Integer id) {
        if (id == null) {
            return null;
        }
        return Arrays.stream(values()).filter(e -> e.id.equals(id)).findFirst().orElse(null);
    }
    /**
     * 根据name()获取枚举
     */
    public static OfflineGoodsTypeEnum getByName(String name) {
        if (StringUtils.isBlank(name)) {
            return null;
        }
        return Arrays.stream(values()).filter(e -> e.name().equals(name)).findFirst().orElse(null);
    }
}
