package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretExtractHistoryDto;

/**
 * 卡密提取历史远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretExtractHistoryService {

    /**
     * 更新卡密提取历史
     *
     * @param dto 卡密提取历史DTO
     * @return 更新数量
     */
    int update(CardSecretExtractHistoryDto dto);

    /**
     * 插入卡密提取历史
     *
     * @param dto 卡密提取历史DTO
     * @return 主键ID
     */
    Long insert(CardSecretExtractHistoryDto dto);

    /**
     * 根据ID查询卡密提取历史
     *
     * @param id 主键ID
     * @return 卡密提取历史DTO
     */
    CardSecretExtractHistoryDto selectById(Long id);


    /**
     * 根据关联任务ID查询卡密提取历史列表
     *
     * @param cardSecretAssociationTaskId 关联任务ID
     * @return 卡密提取历史列表
     */
    List<CardSecretExtractHistoryDto> selectByCardSecretAssociationTaskId(Long cardSecretAssociationTaskId);

    /**
     * 根据批次ID查询卡密提取历史列表
     *
     * @param cardSecretBatchId 批次ID
     * @return 卡密提取历史列表
     */
    List<CardSecretExtractHistoryDto> selectByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 根据操作人ID查询卡密提取历史列表
     *
     * @param operatorId 操作人ID
     * @return 卡密提取历史列表
     */
    List<CardSecretExtractHistoryDto> selectByOperatorId(Long operatorId);

    /**
     * 根据邮箱地址查询卡密提取历史列表
     *
     * @param emailAddress 邮箱地址
     * @return 卡密提取历史列表
     */
    List<CardSecretExtractHistoryDto> selectByEmailAddress(String emailAddress);
}

