package cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.douyincoupon;

import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateExtReq;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 抖音支付券
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class DouYinPayCouponOrderCreateReq extends BaseOrderCreateExtReq {

    /**
     * 活动 ID
     */
    private String activityId;

    /**
     * openid
     */
    private String openid;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 商户id
     */
    private String mchId;

    /**
     * 应用 id
     * 入驻抖音开放平台时分配的应用id。加密手机号发券模式下无需传该参数
     * 示例值:wxd678efh567hg6787
     *
     */
    private String appId;

    /**
     * 访问 token
     * 通过授权码获取到的access token。加密手机号发券模式下无需传该参数
     * 示例值:qswxd678efh5
     */
    private String accessToken;

    /**
     * 用户权限范围
     * 用户授权后，获取到的操作权限范围，用于发用户券鉴权，加密手机号发券模式下无需传该参数
     * 示例值:abc123
     */
    private String scope;
}
