package cn.com.duiba.quanyi.goods.service.api.remoteservice.order.processor.virtual;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.BaseOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.request.virtual.mixuebingcheng.MiXueBingChengOrderCreateReq;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.OrderCreateResult;
import cn.com.duiba.quanyi.goods.service.api.dto.order.processor.result.virtual.mixuebingcheng.MiXueBingChengZcOrderResult;

/**
 * @author xuzhigang
 * @date 2024/6/5 18:15
 **/
@AdvancedFeignClient
public interface RemoteOrderProcessorMiXueBingChengService {
    /**
     * 下单
     *
     * @param req 下单所需参数
     * @return 下单结果
     */
    OrderCreateResult create(BaseOrderCreateReq<MiXueBingChengOrderCreateReq> req);

    /**
     * 查询订单结果
     *
     * @param customerOrderNo 客户订单号
     * @return 订单结果
     */
    MiXueBingChengZcOrderResult findOrderResult(String customerOrderNo);
}
