package cn.com.duiba.quanyi.goods.service.api.param.car;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 汽车服务-门店
 * @author kjj mybatis generator 
 * @date 2024-08-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CarSerStoreSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17228471405149752L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.goods.service.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 省
     */
    private String storeProvince;

    /**
     * 市
     */
    private String storeCity;

    /**
     * 区
     */
    private String storeDistrict;

    /**
     * 详细地址
     */
    private String storeAddress;

    /**
     * 省-行政区划编码
     */
    private String provinceCode;

    /**
     * 市-行政区划编码
     */
    private String cityCode;

    /**
     * 区-行政区划编码
     */
    private String districtCode;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 门店状态
     */
    private Integer storeState;
}