package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretInboundOrderDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretInboundOrderLockParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretInboundOrderSearchParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretInboundOrderUnlockParam;

/**
 * 卡密入库单远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretInboundOrderService {

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    int update(CardSecretInboundOrderDto dto);

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretInboundOrderDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretInboundOrderDto
     */
    CardSecretInboundOrderDto selectById(Long id);


    /**
     * 根据采购单ID查询
     *
     * @param purchaseOrderId 采购单ID
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectByPurchaseOrderId(Long purchaseOrderId);

    /**
     * 根据任务ID查询
     *
     * @param taskId 任务ID
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectByTaskId(Long taskId);

    /**
     * 根据供应商ID查询
     *
     * @param supplierId 供应商ID
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectBySupplierId(Long supplierId);

    /**
     * 根据采购单ID和任务ID查询入库单
     *
     * @param purchaseOrderId 采购单ID
     * @param taskId          任务ID
     * @return 入库单
     */
    CardSecretInboundOrderDto selectByPurchaseOrderIdAndTaskId(Long purchaseOrderId, Long taskId);

    /**
     * 撤销入库单
     *
     * @param inboundOrderId 入库单ID
     * @return 是否撤销成功
     */
    boolean cancelInboundOrder(Long inboundOrderId);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     *
     * @param param 查询条件
     * @return 卡密入库单集合
     */
    List<CardSecretInboundOrderDto> selectPage(CardSecretInboundOrderSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(CardSecretInboundOrderSearchParam param);

    /**
     * 批量锁定入库单
     * 将付款状态改为流程中，apply_payment_amount改为与total_amount一致，设置相关付款字段
     *
     * @param lockParams 锁定参数列表
     * @return 影响行数
     */
    int batchLock(List<CardSecretInboundOrderLockParam> lockParams);

    /**
     * 批量解锁入库单
     * 将付款状态改为未付款，重置相关付款字段为0或空
     *
     * @param ids 解锁参数列表
     * @return 影响行数
     */
    int batchUnlock(List<Long> ids);

    /**
     * 根据ID列表查询简单信息
     *
     * @param idList ID列表
     * @return 入库单列表
     */
    List<CardSecretInboundOrderDto> selectSimpleByIds(List<Long> idList);

}

