package cn.com.duiba.quanyi.goods.service.api.remoteservice.goods;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.goods.SkuStockDto;
import cn.com.duiba.quanyi.goods.service.api.param.goods.SubOrBackParam;

import java.util.List;
import java.util.Map;

/**
 * SKU库存表
 * @author kjj mybatis generator 
 * @date 2024-03-21
 */
@AdvancedFeignClient
public interface RemoteSkuStockService {

    /**
     * 根据sku主键查询
     * @param skuIds sku主键
     * @return SKU库存
     */
    List<SkuStockDto> selectBySkuIds(List<Long> skuIds);


    /**
     * 根据skuId查询
     * @param skuId skuId
     * @return SKU库存
     */
    SkuStockDto selectBySkuId(Long skuId);

    /**
     * 扣减/回退库存
     * @param skuId sku主键
     * @param num 数量（大于0扣减库存，小于0回退库存）
     * @param transactionNo 变更流水号
     */
    boolean subOrBack(Long skuId, Integer num, String transactionNo);

    /**
     * 批量扣减/回退库存
     * @param list 批量库存变更参数
     */
    boolean batchSubOrBack(List<SubOrBackParam> list);
}
