package cn.com.duiba.quanyi.goods.service.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum DouYinCouponCallbackEventTypeEnum {

    INIT("待使用"),
    FREEZE("已冻结"),
    USED("已核销"),
    CNCL("已失效"),
    REFUND("已退款"),//订单整单退款后支付券返回
    ;

    private final String desc;

    private static final Map<String, DouYinCouponCallbackEventTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(Enum::name, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举名称获取枚举
     * @param name 枚举名称
     * @return 枚举
     */
    public static DouYinCouponCallbackEventTypeEnum getByName(String name) {
        if (name == null) {
            return null;
        }
        return ENUM_MAP.get(name);
    }
}
