package cn.com.duiba.quanyi.goods.service.api.param.cardsecret;

import java.util.Date;

import cn.com.duiba.quanyi.goods.service.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 卡密采购单分页查询参数
 * 
 * @author yangyukang
 * @date 2024-09-16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class CardSecretPurchaseOrderPageParam extends PageQuery {

    private static final long serialVersionUID = 1L;

    /**
     * 采购单ID
     */
    private Long id;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 到期开始时间（精确到日）
     */
    private Date expirationStartDate;


    /**
     * 到期结束时间（精确到日）
     */
    private Date expirationEndDate;

    /**
     * 发放类型：1-兑换码，2-固定连接+兑换码，3-链接券，4-账号+密码
     * @see cn.com.duiba.quanyi.goods.service.api.enums.goods.CardSecretTypeEnum
     */
    private Integer cardSecretType;

    /**
     * 供应商ID
     */
    private Long supplierId;

    /**
     * 是否结算：0-不结算，1-结算
     * @see cn.com.duiba.quanyi.goods.service.api.enums.BooleanEnum
     */
    private Integer isSettled;

    /**
     * 状态：1-未入库，2-部分入库，3-已入库
     * @see cn.com.duiba.quanyi.goods.service.api.enums.cardsecret.ReceivingStatusEnum
     */
    private Integer receivingStatus;

}
