package cn.com.duiba.quanyi.goods.service.api.remoteservice.cardsecret;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.goods.service.api.dto.cardsecret.CardSecretAssociationReturnedRecordDto;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretAssociationReturnedRecordQueryParam;
import cn.com.duiba.quanyi.goods.service.api.param.cardsecret.CardSecretAssociationReturnedRecordUpdateParam;

/**
 * 卡密关联退回记录远程服务
 *
 * @author yangyukang
 * @date 2024-09-16
 */
@AdvancedFeignClient
public interface RemoteCardSecretAssociationReturnedRecordService {

    /**
     * 更新
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    int update(CardSecretAssociationReturnedRecordDto dto);

    /**
     * 保存
     *
     * @param dto 参数dto
     * @return 影响行数
     */
    Long insert(CardSecretAssociationReturnedRecordDto dto);

    /**
     * 根据主键ID查询
     *
     * @param id 主键ID
     * @return CardSecretAssociationReturnedRecordDto
     */
    CardSecretAssociationReturnedRecordDto selectById(Long id);


    /**
     * 根据关联任务ID查询
     *
     * @param cardSecretAssociationTaskId 关联任务ID
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectByCardSecretAssociationTaskId(Long cardSecretAssociationTaskId);

    /**
     * 根据关联任务ID集合查询
     *
     * @param cardSecretAssociationTaskIds 关联任务ID集合
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectByCardSecretAssociationTaskIds(List<Long> cardSecretAssociationTaskIds);

    /**
     * 根据批次ID查询
     *
     * @param cardSecretBatchId 批次ID
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectByCardSecretBatchId(Long cardSecretBatchId);

    /**
     * 根据操作人ID查询
     *
     * @param operatorId 操作人ID
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectByOperatorId(Long operatorId);

    /**
     * 根据状态查询
     *
     * @param status 状态
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectByStatus(Integer status);

    /**
     * 根据回退唯一编码查询
     *
     * @param uniqueCode 回退唯一编码
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectByUniqueCode(String uniqueCode);

    /**
     * 统计行数
     *
     * @param queryParam 查询参数
     * @return 行数
     */
    long selectCount(CardSecretAssociationReturnedRecordQueryParam queryParam);

    /**
     * 分页查询
     *
     * @param queryParam 查询参数
     * @return 退回记录列表
     */
    List<CardSecretAssociationReturnedRecordDto> selectPage(CardSecretAssociationReturnedRecordQueryParam queryParam);

    /**
     * 根据主键ID和状态修改退回数量和状态
     *
     * @param updateParam 更新参数
     * @return 影响行数
     */
    int updateReturnQtyAndStatusByIdAndFromStatus(CardSecretAssociationReturnedRecordUpdateParam updateParam);

}
