package cn.com.duiba.quanyi.goods.service.api.enums.cardsecret;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 分配批次类型枚举
 *
 * @author yangyukang
 * @date 2024-12-19
 */
@Getter
@AllArgsConstructor
public enum AllocateTypeEnum {
    NEW(0, "新增"),
    HISTORY(1, "历史"),
    ;

    private final Integer code;
    private final String desc;

    public static AllocateTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (AllocateTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }
}
