package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import req.*;
import req.manage.ActivityBoxListReq;
import req.manage.ActivityListOperateReq;
import rsp.*;
import rsp.manage.ActivityBoxDto;
import rsp.manage.BannerActivityDto;
import rsp.manage.ListActivityDto;

import java.util.List;

/**
 * Created by wsz on 2018/9/7 11:21.
 */
@AdvancedFeignClient
public interface RemoteActivitySetService {
    /**
     * 获取合集首页
     */
    ActivitySetIndexRsp getActivitySetIndex();

    /**
     * 获取合集首页
     */
    ActivitySetIndexRsp getActivitySetIndexV2(ActivitySetIndexReq req);

    /**
     * 获取用户奖励
     */
    ActivitySetUserRewardDto getActivitySetUserReward(ActivitySetIndexReq req);

    /**
     * 获取活动合集文案
     */
    ActivitySetConfigRsp getActivitySetConfig();

    /**
     * 设置活动合集文案
     */
    Boolean setActivitySetConfig(ActivitySetConfigReq req);

    /**
     * 获取banner活动列表
     */
    List<BannerActivityDto> getBannerActivityList();

    /**
     * 获取banner活动
     */
    BannerActivityDto getBannerActivityByActivityId(Long activityId);
    /**
     * 设置banner活动
     */
    Boolean setBannerActivity(BannerActivitySetReq req);

    /**
     * 操作活动
     */
    Boolean operateActivityList(ActivityListOperateReq req);

    /**
     * 获取list活动列表
     */
    List<ListActivityDto> getListActivityList();

    /**
     * 获取list活动
     */
    ListActivityDto getListActivity(Long activityId);

    /**
     * 设置热文活动
     */
    Boolean setHotArticleActivity(HotArticleSetReq req);

    /**
     * 获取宝箱列表
     */
    List<ActivityBoxDto> getActivityBoxList(ActivityBoxListReq req);
    /**
     * 设置活动宝箱
     */
    Boolean setActivityBox(ActivityBoxSetReq req) throws BizException;

    /**
     * 删除活动宝箱
     */
    Boolean deleteActivityBox(Long boxId);

    /**
     * 获取用户活动收益
     */
    UserActivityRewardRecordRsp getUserActivityReward(UserActivityRewardRecordReq req);
}
