package dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;


@ApiModel("应用墙信息")
public class AppWallDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "唯一标示")
    private Long id;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "应用副标题")
    private String appSubName;

    @ApiModelProperty(value = "应用logo")
    private String appLogaUrl;

    @ApiModelProperty(value = "平台，0-安卓，1-IOS")
    private Integer appPlatform;

    @ApiModelProperty(value = "来源，0-优盟")
    private Integer appSource;

    @ApiModelProperty(value = "应用安装包url")
    private String appPackageUrl;

    @ApiModelProperty(value = "安装包名称")
    private String appPackageName;

    @ApiModelProperty(value = "是否上架了，0-未上架，1-已上架")
    private Integer isPublish;

    @ApiModelProperty(value = "是否热门，0-不是热文，1-是热门")
    private Integer isHot;

    @ApiModelProperty(value = "创建时间")
    private Date gmtCreate;

    @ApiModelProperty(value = "修改时间")
    private Date gmtModified;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppSubName(String appSubName) {
        this.appSubName = appSubName;
    }

    public String getAppSubName() {
        return appSubName;
    }

    public void setAppLogaUrl(String appLogaUrl) {
        this.appLogaUrl = appLogaUrl;
    }

    public String getAppLogaUrl() {
        return appLogaUrl;
    }

    public void setAppPlatform(Integer appPlatform) {
        this.appPlatform = appPlatform;
    }

    public Integer getAppPlatform() {
        return appPlatform;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }

    public Integer getAppSource() {
        return appSource;
    }

    public void setAppPackageUrl(String appPackageUrl) {
        this.appPackageUrl = appPackageUrl;
    }

    public String getAppPackageUrl() {
        return appPackageUrl;
    }

    public void setAppPackageName(String appPackageName) {
        this.appPackageName = appPackageName;
    }

    public String getAppPackageName() {
        return appPackageName;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public Integer getIsPublish() {
        return isPublish;
    }

    public void setIsPublish(Integer isPublish) {
        this.isPublish = isPublish;
    }

    public Integer getIsHot() {
        return isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }
}

