package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import req.article.AppArticleShareSuccessReq;
import req.article.ArticleShareHintReq;
import req.article.ArticleShareReadingRewardReq;
import req.article.ArticleShareReq;
import req.article.WechatArticleShareReq;
import req.manage.ArticleShareConfigReqDto;
import rsp.article.ArticleShareHintRsp;
import rsp.article.ArticleShareInfoRsp;
import rsp.article.ArticleShareReadingRewardRsp;
import rsp.article.ArticleShareSuccessRsp;
import rsp.article.WechatShareInfoRsp;
import rsp.manage.ArticleShareConfigRsp;

/**
 * Created by wsz on 2018/9/20 14:13.
 */
@AdvancedFeignClient
public interface RemoteArticleShareService {

    /**
     * 更新配置
     */
    Boolean updateConfig(ArticleShareConfigReqDto req);

    /**
     * 获取配置
     */
    ArticleShareConfigRsp getConfig();

    /**
     * 获取app分享信息
     */
    ArticleShareInfoRsp getAppShareInfo(ArticleShareReq req);

    /**
     * 获取气泡提示文案
     */
    ArticleShareHintRsp getHintContent(ArticleShareHintReq req);

    /**
     * 关闭气泡提示
     */
    Boolean closeHint(ArticleShareHintReq req);

    /**
     * app分享成功
     */
    ArticleShareSuccessRsp shareSuccessApp(AppArticleShareSuccessReq req);

    /**
     * 获取微信分享信息
     */
    WechatShareInfoRsp getWechatShareInfo(WechatArticleShareReq req);

    /**
     * 获取最新好友阅读奖励记录
     */
    ArticleShareReadingRewardRsp getReadingReward(ArticleShareReadingRewardReq req);
}
