package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum SceneType {
                          /**
                           * 原生
                           */
                          APP(0),
                            /**
                            * H5
                            */
                            WE_CHAT(1),

    ;

    private Integer type;

    public Integer getType() {
        return type;
    }

    SceneType(Integer type) {
        this.type = type;
    }


    private static final Map<Integer, SceneType> CACHE = Maps.uniqueIndex(Arrays.asList(SceneType
            .values()), SceneType::getType);

    public static SceneType of(Integer type) {
        return CACHE.get(type);
    }


}
