package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import req.BaseQueryReq;
import req.ShareHotArticleReq;
import req.ShareHotArticleSuccessReq;
import req.WechatShareInfoReq;
import rsp.HotArticleCommentDto;
import rsp.HotArticleQueryRsp;
import rsp.ShareHotArticleRsp;

import java.util.List;

/**
 * Created by wsz on 2018/9/3 10:15.
 */
@AdvancedFeignClient
public interface RemoteHotArticleService {
     List<HotArticleQueryRsp> selectByPage(BaseQueryReq baseQueryReq);

     HotArticleQueryRsp selectByHotArticleId(Long hotArticleId);
     /**
      * 获取热文评论
      * @param hotArticleId
      * @return
      */
     List<HotArticleCommentDto> getHotArticleComment(Long hotArticleId);

     /**
      * 获取app热文分享信息
      * @param shareHotArticleReq
      * @return
      */
     ShareHotArticleRsp getAppShareInfo(ShareHotArticleReq shareHotArticleReq);

     /**
      * 获取微信分享信息
      * @param wechatShareInfoReq
      * @return
      */
     ShareHotArticleRsp getWechatShareInfo(WechatShareInfoReq wechatShareInfoReq);

     /**
      * 热文分享成功
      * @param shareHotArticleSuccessReq
      */
     Boolean hotArticleShareSuccess(ShareHotArticleSuccessReq shareHotArticleSuccessReq);
}
