package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * Created by wsz on 2018/9/7 15:39.
 */
public enum ActivitySetConfigEnum {
    HEADER_CONFIG("headerConfig","合集头部配置"),
    ;

    private String configName;
    private String desc;
    private static final Map<String, ActivitySetConfigEnum> CACHE = Maps.uniqueIndex(Arrays.asList(ActivitySetConfigEnum
            .values()), ActivitySetConfigEnum::getConfigName);

    ActivitySetConfigEnum(String configName, String desc) {
        this.configName = configName;
        this.desc = desc;
    }

    public static ActivitySetConfigEnum getByConfigName(String name) {
        return CACHE.get(name);
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getConfigName() {
        return configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }
}
