package cn.com.duiba.quwen.fun.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import req.AppUserReq;
import req.manage.signin.SignInBaseConfigEditReqDto;
import req.manage.signin.SignInContentEditReqDto;
import req.manage.signin.SignInContentQueryReqDto;
import req.manage.signin.SignInContentStatusReqDto;
import rsp.manage.signin.SignInBaseConfigRspDto;
import rsp.manage.signin.SignInContentRspDto;
import rsp.signin.UserSignInContentDto;

import java.util.List;

/**
 * @author wsz
 * @date 2018/10/11 17:04
 * 签到活动接口
 */
@AdvancedFeignClient
public interface RemoteSignInService {
    /********** 管理端 ************/
    /**
     * 获取基本项配置
     */
    SignInBaseConfigRspDto getBaseConfig();

    /**
     * 更新基本项配置
     */
    Boolean updateBaseConfig(SignInBaseConfigEditReqDto req);

    /**
     * 获取签到内容列表
     */
    List<SignInContentRspDto> getSignInContentList();

    /**
     * 更新签到内容状态
     */
    Boolean updateSignInContentStatus(SignInContentStatusReqDto req);

    /**
     * 获取签到内容列表
     */
    SignInContentRspDto getSignInContent(SignInContentQueryReqDto req);

    /**
     * 编辑签到内容
     */
    Boolean editSignInContent(SignInContentEditReqDto req);


    /******** app端 **********/
    /**
     * 获取用户今日签内容
     */
    UserSignInContentDto getUserSignInContent(AppUserReq req);


}
