package dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;

@ApiModel("热文微信小程序推送消息DTO")
public class ArticleMiniProgramMessageDto implements Serializable {

    private static final long serialVersionUID = -3180468783004869000L;

    @ApiModelProperty(value = "唯一ID")
    private Long id;
    @ApiModelProperty(value = "主标题")
    private String mainTitle;
    @ApiModelProperty(value = "内容标题")
    private String contentTitle;
    @ApiModelProperty(value = "主题")
    private String theme;
    @ApiModelProperty(value = "内容描述")
    private String contentDesc;
    @ApiModelProperty(value = "是否关联内容，0-不关联，1-关联")
    private Integer isRelationContent;
    @ApiModelProperty(value = "关联文章id")
    private Long relationArticleId;
    @ApiModelProperty(value = "推送时间")
    private Date pushTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMainTitle() {
        return mainTitle;
    }

    public void setMainTitle(String mainTitle) {
        this.mainTitle = mainTitle;
    }

    public String getContentTitle() {
        return contentTitle;
    }

    public void setContentTitle(String contentTitle) {
        this.contentTitle = contentTitle;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getContentDesc() {
        return contentDesc;
    }

    public void setContentDesc(String contentDesc) {
        this.contentDesc = contentDesc;
    }

    public Integer getIsRelationContent() {
        return isRelationContent;
    }

    public void setIsRelationContent(Integer isRelationContent) {
        this.isRelationContent = isRelationContent;
    }

    public Long getRelationArticleId() {
        return relationArticleId;
    }

    public void setRelationArticleId(Long relationArticleId) {
        this.relationArticleId = relationArticleId;
    }

    public Date getPushTime() {
        return pushTime;
    }

    public void setPushTime(Date pushTime) {
        this.pushTime = pushTime;
    }
}
