package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum ActivityType {
    /**
     * 限时红包
     */
    TIME_LIMIT_PACKET(1),
    /**
     * 邀请好友
     */
    INVITE_DETAIL(2),
    /**
     * 群红包
     */
    GROUP_RED_PACKET(3),

    /**
     * 点点赚
     */
    CLICK_TWICE_EARN(4),

    /**
     * 签到分享
     */
    SIGN_IN_SHARE(5),

    /**
     * 热文
     */
    HOT_ARTICLE(6),

    /**
     * 正文分享
     */
    ARTICLE_SHARE(8),

    /**
     * 微信热文
     */
    WECHAT_HOT_ARTICLE(9),
    ;

    private Integer type;

    public Integer getType() {
        return type;
    }

    ActivityType(Integer type) {
        this.type = type;
    }


    private static final Map<Integer, ActivityType> CACHE = Maps.uniqueIndex(Arrays.asList(ActivityType
            .values()), ActivityType::getType);

    public static ActivityType of(Integer type) {
        return CACHE.get(type);
    }


}
