package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum ActivityTypeChange {
    /**
     * 限时红包
     */
    TIME_LIMIT_PACKET(1,"timeLimitPacket","限时红包"),
    /**
     * 邀请好友
     */
    INVITE_DETAIL(2,"inviteDetail","邀请好友"),
    /**
     * 群红包
     */
    GROUP_RED_PACKET(3,"groupRedPacket","群红包"),

    /**
     * 点点赚
     */
    CLICK_TWICE_EARN(4,"clickTwiceEarn","点点赚"),

    /**
     * 签到分享
     */
    SIGN_IN_SHARE(5,"signInShare","签到分享");

    private Integer code;

    private String  type;

    private String  decs;


    ActivityTypeChange(Integer code, String type, String decs) {
        this.code = code;
        this.type = type;
        this.decs = decs;
    }

    public Integer getCode() {
        return code;
    }


    public String getType() {
        return type;
    }

    public String getDecs() {
        return decs;
    }

    public static final Map<String, ActivityTypeChange> CACHE = Maps.uniqueIndex(Arrays.asList(ActivityTypeChange
            .values()), ActivityTypeChange::getType);

    public static final Map<Integer, ActivityTypeChange> CACHEV2 = Maps.uniqueIndex(Arrays.asList(ActivityTypeChange
            .values()), ActivityTypeChange::getCode);

    public static ActivityTypeChange of(String type) {
        return CACHE.get(type);
    }


}
