package enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum JumpType {
                          /**
                           * 原生
                           */
                          NATIVE(1),
                            /**
                            * H5
                            */
                            H5(2),

    ;

    private Integer type;

    public Integer getType() {
        return type;
    }

    JumpType(Integer type) {
        this.type = type;
    }


    private static final Map<Integer, JumpType> CACHE = Maps.uniqueIndex(Arrays.asList(JumpType
            .values()), JumpType::getType);

    public static JumpType of(Integer type) {
        return CACHE.get(type);
    }


}
