package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * Cookie类型
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyCookieDecodeType {

    PLAIN_TEXT(1, "明文"),
    BASE64(2, "Base64");

    private int    value;
    private String desc;

    RatelimitPolicyCookieDecodeType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitPolicyCookieDecodeType get(int value) {
        for (RatelimitPolicyCookieDecodeType item : RatelimitPolicyCookieDecodeType.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
