package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * 限流规则的失效类型
 * Created by guoyanfei .
 * 2018/7/30 .
 */
public enum RatelimitPolicyExpireType {

    VALID_FOREVER(1, "不自动失效"),
    EXPIRE_TIME(2, "有效期失效");

    private int    value;
    private String desc;

    RatelimitPolicyExpireType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

    public static RatelimitPolicyExpireType get(int value) {
        for (RatelimitPolicyExpireType item : RatelimitPolicyExpireType.values()) {
            if (item.value() == value) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
