package cn.com.duiba.ratelimit.service.api.enums;

import cn.com.duiba.ratelimit.service.api.exception.RatelimitException;

/**
 * Created by guoyanfei .
 * 2018/8/9 .
 */
public enum RatelimitPolicyMatchingMode {

    EQUALS("="),
    NOT_EQUALS("!="),
    STARTS_WITH("startsWith"),
    CONTAINS("contains"),
    NOT_CONTAINS("!contains");

    private String key;

    RatelimitPolicyMatchingMode(String key) {
        this.key = key;
    }

    public String key() {
        return key;
    }

    public static RatelimitPolicyMatchingMode get(String key) {
        for (RatelimitPolicyMatchingMode item : RatelimitPolicyMatchingMode.values()) {
            if (item.key().equals(key)) {
                return item;
            }
        }
        throw new RatelimitException("invalid enum value!");
    }
}
