package cn.com.duiba.reports.biz.api.enums;

/**
 * @author xugf
 * druid 维度字段
 */
public enum DruidDimensionEnum {

    //媒体id
    APP_ID("app_id", "appId", "媒体id"),

    //广告位id
    SLOT_ID("slot_id", "slotId", "广告位id"),

    //活动id
    ACTIVITY_ID("activity_id", "activityId", "活动id"),

    //广告id
    ADVERT_ID("advert_id", "advertId", "广告id"),

    //素材ID
    MATERIAL_ID("material_id", "materialId", "素材ID"),

    //广告定向配置id，0为默认配置
    ORIENTATION_ID("orientation_id", "orientationId", "广告定向配置id，0为默认配置"),

    //广告主账户id
    ACCOUNT_ID("account_id", "accountId", "广告主账户id"),

    //代理商id
    AGENT_ID("agent_id", "agentId", "代理商id"),

    //ADX推广组id
    GROUP_ID("group_id", "groupId", "ADX推广组id"),

    //ADX资源位id
    RESOURCE_ID("resource_id", "resourceId", "ADX资源位id"),

    //ADX创意id
    IDEA_ID("idea_id", "ideaId", "ADX创意id"),

    //创建App的来源 0：积分商城（兑吧） 1：广告平台（推啊）
    APP_SOURCE("app_source", "appSource", "创建App的来源 0：积分商城（兑吧） 1：广告平台（推啊）"),

    //媒体性质 1-在线KA,2-潜力KA,3-普通媒体
    APP_LEVEL("app_level", "appLevel", "媒体性质 1-在线KA,2-潜力KA,3-普通媒体"),

    //媒体类型 1-android，2-ios，3-js
    APP_TYPE("app_type", "appType", "媒体类型 1-android，2-ios，3-js"),

    //广告位接入方式 1:sdk,2.手动投放（接入api),3.手动投放（不接入api）
    SLOT_ACCESS_TYPE("slot_access_type", "slotAccessType", "广告位接入方式 1:sdk,2.手动投放（接入api),3.手动投放（不接入api）"),

    //目标转化类型（广告配置的一个属性）
    TARGET_EFFECT_TYPE("target_effect_type", "targetEffectType", "目标转化类型（广告配置的一个属性）"),

    //1表示表单类广告
    FORM_ADVERT("form_advert", "formAdvert", "1表示表单类广告"),

    //是否免费 (0:收费 1:免费)
    IS_FREE("is_free", "isFree", "是否免费 (0:收费 1:免费)"),

    //ae区域  1-华东，2-华北 3-其他
    AE_AREA("ae_area", "aeArea", "ae区域  1-华东，2-华北 3-其他"),

    //广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）
    ADVERT_TYPE("advert_type", "advertType", "广告类型（推啊 -1-互动式广告，4-展示广告，6-激励广告）"),

    //活动来源 (0-兑吧 1-推啊)
    ACTIVITY_SOURCE("activity_source", "activitySource", "活动来源 (0-兑吧 1-推啊)"),

    //广告位投放活动的类型（1-插件工具、2-普通活动、3-直投页、4-自定义活动）
    ACTIVITY_TYPE("activity_type", "activityType", "广告位投放活动的类型（1-插件工具、2-普通活动、3-直投页、4-自定义活动）"),

    //活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）
    ACTIVITY_RELEASE_MODE("activity_release_mode", "activityReleaseMode", "活动投放模式（1:直投 2: 一次返回拦截 3: 二次返回拦截 4:浮标 5:推荐弹层 6:谢谢参与弹层）"),

    //广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0
    ACTIVITY_RELEASE_SUB_MODE("activity_release_sub_mode", "activityReleaseSubMode", "广告位上直投活动的投放方式：仅投1 优投人工2 优投算法3 纯算法4 其他0"),

    //广告位投放内容类型 1:活动、2：直投页、3：自定义活动
    RELEASE_CONTENT_TYPE("release_content_type", "releaseContentType", "广告位投放内容类型 1:活动、2：直投页、3：自定义活动"),

    //adx投放方式 0依次 1按比例 2按算法
    ADX_PUT_TYPE("adx_put_type", "adxPutType", "adx投放方式 0依次 1按比例 2按算法"),

    //生效的主体类型，1-杭州推啊，2-霍尔果斯推啊
    COMPANY_ID("company_id", "companyId", "生效的主体类型，1-杭州推啊，2-霍尔果斯推啊"),

    //风控类型 0：正常，1：用户作弊，2：广告位作弊
    RISK_TYPE("risk_type", "riskType", "风控类型 0：正常，1：用户作弊，2：广告位作弊"),

    //广告位素材id
    SLOT_MATERIAL_ID("slot_material_id", "slotMaterialId", "广告位素材id"),

    //广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级
    SLOT_MATERIAL_PUT_TYPE("slot_material_put_type", "slotMaterialPutType", "广告位素材投放方式：0-人工 1-算法1.0 2-算法2.0 3-算法返回null降级"),

    //插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0
    PLUGIN_PUT_TYPE("plugin_put_type", "pluginPutType", "插件投放类型 1-分流算法3.0，2-配置大盘默认，3-配置活动，4-配置广告位定制，5-配置算法，6-盘古，7-分流算法2.0");


    //druid 中表定义的字段名称
    private String tableFieldName;

    //结果数据对应的别名
    private String resultFieldName;

    //维度解释说明
    private String desc;

    DruidDimensionEnum(String tableFieldName, String resultFieldName, String desc) {
        this.tableFieldName = tableFieldName;
        this.resultFieldName = resultFieldName;
        this.desc = desc;
    }

    public String getTableFieldName() {
        return tableFieldName;
    }

    public String getResultFieldName() {
        return resultFieldName;
    }

    public String getDesc() {
        return desc;
    }}
