package cn.com.duiba.reports.biz.api.enums;

/**
 * @author xugf
 * druid指标字段
 */
public enum DruidMetricEnum {

    //广告位曝光pv
    SLOT_EXPOSURE_PV("slotExposurePV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type in ('2', '151')", "广告位曝光pv"),

    //广告位曝光uv
    SLOT_EXPOSURE_UV("slotExposureUV", "count(distinct device_uv)", "duiba_inner_log", "inner_group = '1' and inner_type in ('2', '151')", "广告位曝光uv"),

    //广告位点击pv
    SLOT_CLICK_PV("slotClickPV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type in ('3', '152')", "广告位点击pv"),

    //广告位点击uv
    SLOT_CLICK_UV("slotClickUV", "count(distinct device_uv)", "duiba_inner_log", "inner_group = '1' and inner_type in ('3', '152')", "广告位点击uv"),

    //广告位访问pv
    SLOT_VISIT_PV("slotVisitPV", "sum(count_pv)", "duiba_access_log", "url_host = 'activity.tuia.cn' and http_method = 'GET' and tenter='SOW'", "广告位访问pv"),

    //广告位访问uv
    SLOT_VISIT_UV("slotVisitUV", "count(distinct consumer_uv)", "duiba_access_log", "url_host = 'activity.tuia.cn' and http_method = 'GET' and tenter='SOW'", "广告位访问uv"),

    //媒体线-活动请求pv
    APP_ACTIVITY_REQUEST_PV("appActivityRequestPV", "sum(count_pv)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex')", "活动请求pv"),

    //媒体线-活动请求uv
    APP_ACTIVITY_REQUEST_UV("appActivityRequestUV", "count(distinct consumer_uv)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/index','/mainmeet/index','/actcenter/index','/direct/index','/plugintools/timingindex','/plugintools/index','/plugintools/embeddedindex','/plugintools/responsiveindex')", "活动请求uv"),

    //媒体线-活动参与pv
    APP_ACTIVITY_JOIN_PV("appActivityJoinPV", "sum(count_pv)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与pv"),

    //媒体线-活动参与uv
    APP_ACTIVITY_JOIN_UV("appActivityJoinUV", "count(distinct consumer_uv)", "duiba_access_log", "url_host = 'activity.tuia.cn' and url_path in ('/activity/dojoin','/plugintools/dojoin')", "活动参与uv"),

    //活动线-活动请求pv
    ACTIVITY_REQUEST_PV("activityRequestPV", "sum(count_pv)", "duiba_access_log", "activity_stage = '2'", "活动请求pv"),

    //活动线-活动请求uv
    ACTIVITY_REQUEST_UV("activityRequestUV", "count(distinct consumer_uv)", "duiba_access_log", "activity_stage = '2'", "活动请求uv"),

    //活动线-活动参与pv
    ACTIVITY_JOIN_PV("activityJoinPV", "sum(count_pv)", "duiba_access_log", "activity_stage = '3'", "活动参与pv"),

    //活动线-活动参与uv
    ACTIVITY_JOIN_UV("activityJoinUV", "count(distinct consumer_uv)", "duiba_access_log", "activity_stage = '3'", "活动参与uv"),

    //券请求pv
    COUPON_REQUEST_PV("couponRequestPV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type = '23'", "券请求pv"),

    //发券量pv
    LAUNCH_COUPON_PV("launchCouponPV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type = '20'", "发券量pv"),

    //券曝光pv
    COUPON_EXPOSURE_PV("couponExposurePV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type = '22'", "券曝光pv"),

    //券点击pv
    COUPON_CLICK_PV("couponClickPV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type = '25'", "券点击pv"),

    //消耗
    CONSUME("consume", "sum(fee)", "duiba_inner_log", "inner_group = '1' and inner_type = '25'", "消耗"),

    //落地页曝光pv
    LP_EXPOSE_PV("lpExposePV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type = '7'", "落地页曝光pv"),

    //落地页转化pv
    LP_CLICK_PV("lpClickPV", "sum(count_pv)", "duiba_inner_log", "inner_group = '1' and inner_type = '8'", "落地页转化pv");



    //指标字段名称
    private String fieldName;

    //指标sql代码段
    private String metricSql;

    //指标对应的 database
    private String database;

    //指标特定的查询条件
    private String condition;

    //指标解释说明
    private String desc;

    DruidMetricEnum(String fieldName, String metricSql, String database, String condition, String desc) {
        this.fieldName = fieldName;
        this.metricSql = metricSql;
        this.database = database;
        this.condition = condition;
        this.desc = desc;
    }

    public String getFieldName() {
        return fieldName;
    }

    public String getMetricSql() {
        return metricSql;
    }

    public String getDatabase() {
        return database;
    }

    public String getCondition() {
        return condition;
    }

    public String getDesc() {
        return desc;
    }
}
