/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.enums.wechat;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WxErrorCodeEnum {
    E_10000("-10000", "\u9519\u8bef\u7801\u6682\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94"),
    E_8("-8", "\u8bf7\u6c42\u53d1\u9001\u5f02\u5e38"),
    E_7("-7", "httpclient \u53d1\u9001\u8bf7\u6c42\u65f6\u9519\u8bef"),
    E_6("-6", "\u529f\u80fd\u4e0b\u7ebf"),
    E_5("-5", "\u53c2\u6570\u9519\u8bef"),
    E_4("-4", "\u8bf7\u6c42\u6ca1\u6709\u56de\u590d"),
    E_3("-3", "\u914d\u7f6e\u4e0d\u53d1\u9001\u6d88\u606f"),
    E_2("-2", "\u53c2\u6570\u4e3a\u7a7a"),
    E_1("-1", "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u5f00\u53d1\u8005\u91cd\u8bd5"),
    E0("0", "\u8bf7\u6c42\u6210\u529f"),
    E41041("41041", "\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u8d85\u8fc7\u9650\u5236");

    private static final Logger log;
    private String code;
    private String desc;
    private static Map<String, WxErrorCodeEnum> valueMap;

    private WxErrorCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WxErrorCodeEnum getByCode(String code) {
        if (Objects.isNull(code)) {
            return null;
        }
        WxErrorCodeEnum wxErrorCodeEnum = valueMap.get(code);
        if (Objects.isNull((Object)wxErrorCodeEnum)) {
            log.warn("wx error code miss {}", (Object)code);
            return E_10000;
        }
        return wxErrorCodeEnum;
    }

    static {
        log = LoggerFactory.getLogger(WxErrorCodeEnum.class);
        valueMap = new HashMap<String, WxErrorCodeEnum>();
        for (WxErrorCodeEnum value : WxErrorCodeEnum.values()) {
            valueMap.put(value.getCode(), value);
        }
    }
}

