package cn.com.duiba.scrm.common.factory;

/**
 * redis key
 */
public enum RedisKeyFactory {

    K001("企微应用accessToken"),
    K002("企微应用获取accessToken分布式锁"),
    K003("企微应用ticket"),
    K004("服务商accessToken"),
    K005("服务商获取accessToken分布式锁 "),
    K006("授权企业accessToken"),
    K007("授权企业获取accessToken分布式锁"),
    K008("同步企业成员分布式锁"),
    K009("同步企业群组分布式锁"),
    K010("同步企业标签分布式锁"),
    K011("上传微信素材mediaId缓存"),

    ;

    private static final String SPACE = "SCRMCenter";
    private static final String SEPARATOR = "_";

    String desc;

    RedisKeyFactory(String desc){
        this.desc = desc;
    }

    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    @Override
    public String toString(){
        return SPACE +SEPARATOR+ this.name();
    }
}
