/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.enums.wechat;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum WxErrorCodeEnum {
    E_10000("-10000", "\u9519\u8bef\u7801\u6682\u65f6\u627e\u4e0d\u5230\u5bf9\u5e94"),
    E_8("-8", "\u8bf7\u6c42\u53d1\u9001\u5f02\u5e38"),
    E_7("-7", "httpclient \u53d1\u9001\u8bf7\u6c42\u65f6\u9519\u8bef"),
    E_6("-6", "\u529f\u80fd\u4e0b\u7ebf"),
    E_5("-5", "\u53c2\u6570\u9519\u8bef"),
    E_4("-4", "\u8bf7\u6c42\u6ca1\u6709\u56de\u590d"),
    E_3("-3", "\u914d\u7f6e\u4e0d\u53d1\u9001\u6d88\u606f"),
    E_2("-2", "\u53c2\u6570\u4e3a\u7a7a"),
    E_1("-1", "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u5f00\u53d1\u8005\u91cd\u8bd5"),
    E0("0", "\u8bf7\u6c42\u6210\u529f"),
    E40014("40014", "\u4e0d\u5408\u6cd5\u7684access_token"),
    E40029("40029", "\u4e0d\u5408\u6cd5\u7684oauth_code"),
    E40098("40098", "\u90e8\u5206\u5458\u5de5\u672a\u5b9e\u540d\u8ba4\u8bc1"),
    E40099("40099", "\u5916\u90e8\u8054\u7cfb\u4eba\u7684\u6570\u91cf\u5df2\u8fbe\u4e0a\u9650"),
    E40100("40100", "\u6b64\u7528\u6237\u7684\u5916\u90e8\u8054\u7cfb\u4eba\u5df2\u7ecf\u5728\u8f6c\u79fb\u6d41\u7a0b\u4e2d"),
    E40123("40123", "\u4e0a\u4f20\u4e34\u65f6\u56fe\u7247\u7d20\u6750\uff0c\u56fe\u7247\u683c\u5f0f\u975e\u6cd5"),
    E40124("40124", "\u63a8\u5e7f\u6d3b\u52a8\u91cc\u7684sn\u7981\u6b62\u7ed1\u5b9a"),
    E41037("41037", "\u7f3a\u5c11\u300c\u8054\u7cfb\u6211\u300dtype\u53c2\u6570"),
    E41038("41038", "\u7f3a\u5c11\u300c\u8054\u7cfb\u6211\u300dscene\u53c2\u6570"),
    E41039("41039", "\u65e0\u6548\u7684\u300c\u8054\u7cfb\u6211\u300dtype\u53c2\u6570"),
    E41040("41040", "\u65e0\u6548\u7684\u300c\u8054\u7cfb\u6211\u300dscene\u53c2\u6570"),
    E41041("41041", "\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u8d85\u8fc7\u9650\u5236"),
    E41042("41042", "\u65e0\u6548\u7684\u300c\u8054\u7cfb\u6211\u300dstyle\u53c2\u6570"),
    E41043("41043", "\u7f3a\u5c11\u300c\u8054\u7cfb\u6211\u300dconfig_id\u53c2\u6570"),
    E41044("41044", "\u65e0\u6548\u7684\u300c\u8054\u7cfb\u6211\u300dconfig_id\u53c2\u6570"),
    E41045("41045", "\u6dfb\u52a0\u300c\u8054\u7cfb\u6211\u300d\u8fbe\u5230100\u4eba\u6570\u91cf\u4e0a\u9650"),
    E41046("41046", "\u7f3a\u5c11\u4f01\u4e1a\u7fa4\u53d1\u6d88\u606fid"),
    E41047("41047", "\u65e0\u6548\u7684\u4f01\u4e1a\u7fa4\u53d1\u6d88\u606fid"),
    E41048("41048", "\u65e0\u53ef\u53d1\u9001\u7684\u5ba2\u6237"),
    E41049("41049", "\u7f3a\u5c11\u6b22\u8fce\u8bedcode\u53c2\u6570"),
    E41050("41050", "\u65e0\u6548\u7684\u6b22\u8fce\u8bedcode"),
    E41051("41051", "\u5ba2\u6237\u548c\u670d\u52a1\u4eba\u5458\u5df2\u7ecf\u5f00\u59cb\u804a\u5929\u4e86"),
    E41052("41052", "\u65e0\u6548\u7684\u53d1\u9001\u65f6\u95f4"),
    E41053("41053", "\u5ba2\u6237\u672a\u540c\u610f\u804a\u5929\u5b58\u6863"),
    E41054("41054", "\u8be5\u7528\u6237\u5c1a\u672a\u6fc0\u6d3b"),
    E41055("41055", "\u7fa4\u6b22\u8fce\u8bed\u6a21\u677f\u6570\u91cf\u8fbe\u5230\u4e0a\u9650"),
    E41056("41056", "\u5916\u90e8\u8054\u7cfb\u4ebaid\u7c7b\u578b\u4e0d\u6b63\u786e"),
    E41057("41057", "\u4f01\u4e1a\u6216\u670d\u52a1\u5546\u672a\u7ed1\u5b9a\u5fae\u4fe1\u5f00\u53d1\u8005\u8d26\u53f7"),
    E41059("41059", "\u7f3a\u5c11moment_id\u53c2\u6570"),
    E41060("41060", "\u4e0d\u5408\u6cd5\u7684moment_id\u53c2\u6570"),
    E41061("41061", "\u4e0d\u5408\u6cd5\u670b\u53cb\u5708\u53d1\u9001\u6210\u5458userid\uff0c\u5f53\u524d\u670b\u53cb\u5708\u5e76\u975e\u6b64\u7528\u6237\u53d1\u8868"),
    E41062("41062", "\u4f01\u4e1a\u521b\u5efa\u7684\u670b\u53cb\u5708\u5c1a\u672a\u88ab\u6210\u5458userid\u53d1\u8868"),
    E41063("41063", "\u7fa4\u53d1\u6d88\u606f\u6b63\u5728\u88ab\u6d3e\u53d1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"),
    E41064("41064", "\u9644\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236"),
    E41065("41065", "\u65e0\u6548\u7684\u9644\u4ef6\u7c7b\u578b"),
    E41066("41066", "\u7528\u6237\u89c6\u9891\u53f7\u540d\u79f0\u9519\u8bef"),
    E41067("41067", "\u670b\u53cb\u5708moment_id\u7c7b\u578b\u9519\u8bef"),
    E41102("41102", "\u7f3a\u5c11\u83dc\u5355\u540d"),
    E42001("42001", "access_token\u5df2\u8fc7\u671f"),
    E42007("42007", "pre_auth_code\u5df2\u8fc7\u671f"),
    E42009("42009", "suite_access_token\u5df2\u8fc7\u671f"),
    E42012("42012", "jsapi_ticket\u4e0d\u53ef\u7528\uff0c\u4e00\u822c\u662f\u6ca1\u6709\u6b63\u786e\u8c03\u7528\u63a5\u53e3\u6765\u521b\u5efajsapi_ticket"),
    E42013("42013", "\u5c0f\u7a0b\u5e8f\u672a\u767b\u9646\u6216\u767b\u5f55\u6001\u5df2\u7ecf\u8fc7\u671f");

    private static final Logger log;
    private String code;
    private String desc;
    private static Map<String, WxErrorCodeEnum> valueMap;

    private WxErrorCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static WxErrorCodeEnum getByCode(String code) {
        if (Objects.isNull(code)) {
            return null;
        }
        WxErrorCodeEnum wxErrorCodeEnum = valueMap.get(code);
        if (Objects.isNull((Object)wxErrorCodeEnum)) {
            log.warn("wx error code miss {}", (Object)code);
            return E_10000;
        }
        return wxErrorCodeEnum;
    }

    static {
        log = LoggerFactory.getLogger(WxErrorCodeEnum.class);
        valueMap = new HashMap<String, WxErrorCodeEnum>();
        for (WxErrorCodeEnum value : WxErrorCodeEnum.values()) {
            valueMap.put(value.getCode(), value);
        }
    }
}

